/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.ListenerStorage;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.deleter.tasks.IDeletionTask;

public class TaskStorage
extends SavedData {
    GenTaskStorage storage = new GenTaskStorage(() -> ((TaskStorage)this).m_77762_());
    SimpleTaskStorage<IDeletionTask> deletion = new SimpleTaskStorage<IDeletionTask>(() -> ((TaskStorage)this).m_77762_(), IDeletionTask::loadTask, IDeletionTask::saveTask);
    ListenerStorage listeners = new ListenerStorage();

    public static TaskStorage loadData(CompoundTag nbt) {
        TaskStorage storage = new TaskStorage();
        storage.load(nbt);
        return storage;
    }

    public void load(CompoundTag nbt) {
        this.storage.read(nbt.m_128469_("generation"));
        this.deletion.read(nbt.m_128469_("deletion"));
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128365_("generation", (Tag)this.storage.write(new CompoundTag()));
        compound.m_128365_("deletion", (Tag)this.deletion.write(new CompoundTag()));
        return compound;
    }

    public static GenTaskStorage getGenStorage() {
        return TaskStorage.getStorage().storage;
    }

    public static SimpleTaskStorage<IDeletionTask> getDeletionStorage() {
        return TaskStorage.getStorage().deletion;
    }

    public static ListenerStorage getListeners() {
        return TaskStorage.getStorage().listeners;
    }

    public static TaskStorage getStorage() {
        return (TaskStorage)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(TaskStorage::loadData, TaskStorage::new, "pregen_storage");
    }

    public static Set<String> getActiveTasks() {
        ObjectLinkedOpenHashSet s = new ObjectLinkedOpenHashSet();
        s.addAll(TaskStorage.getGenStorage().getActiveTasks());
        s.addAll(TaskStorage.getDeletionStorage().getActiveTasks());
        return s;
    }

    public static Set<String> getTasks() {
        ObjectLinkedOpenHashSet s = new ObjectLinkedOpenHashSet();
        s.addAll(TaskStorage.getGenStorage().getTasks());
        s.addAll(TaskStorage.getDeletionStorage().getTasks());
        return s;
    }
}

